### 11.5. 创建一个可执行jar

让我们通过创建一个完全自包含的可执行jar文件来结束我们的示例，该jar文件可以在生产环境运行。可执行jars（有时候被成为胖jars "fat jars"）是包含你的编译后的类和你的代码运行所需的依赖jar的存档。

**可执行jars和Java**：Java没有提供任何标准的加载内嵌jar文件（即jar文件中还包含jar文件）的方法。如果你想发布一个自包含的应用这就是一个问题。为了解决该问题，很多开发者采用"共享的"jars。一个共享的jar简单地将来自所有jars的类打包进一个单独的“超级jar”。采用共享jar方式的问题是很难区分在你的应用程序中可以使用哪些库。在多个jars中如果存在相同的文件名（但内容不一样）也会是一个问题。Spring Boot采取一个[不同的途径](../X. Appendices/D. The executable jar format.md)，并允许你真正的内嵌jars。

为了创建可执行的jar，需要将`spring-boot-maven-plugin`添加到我们的pom.xml中。在dependencies节点下插入以下内容：
```xml
<build>
    <plugins>
        <plugin>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-maven-plugin</artifactId>
        </plugin>
    </plugins>
</build>
```
**注**：`spring-boot-starter-parent` POM包含用于绑定repackage目标的`<executions>`配置。如果你不使用parent POM，你将需要自己声明该配置。具体参考[插件文档](http://docs.spring.io/spring-boot/docs/1.3.0.BUILD-SNAPSHOT/maven-plugin/usage.html)。

保存你的pom.xml，然后从命令行运行`mvn package`：
```shell
$ mvn package

[INFO] Scanning for projects...
[INFO]
[INFO] ------------------------------------------------------------------------
[INFO] Building myproject 0.0.1-SNAPSHOT
[INFO] ------------------------------------------------------------------------
[INFO] .... ..
[INFO] --- maven-jar-plugin:2.4:jar (default-jar) @ myproject ---
[INFO] Building jar: /Users/developer/example/spring-boot-example/target/myproject-0.0.1-SNAPSHOT.jar
[INFO]
[INFO] --- spring-boot-maven-plugin:1.3.0.BUILD-SNAPSHOT:repackage (default) @ myproject ---
[INFO] ------------------------------------------------------------------------
[INFO] BUILD SUCCESS
[INFO] ------------------------------------------------------------------------
```
如果查看target目录，你应该看到`myproject-0.0.1-SNAPSHOT.jar`。该文件应该有10Mb左右的大小。如果想偷看内部结构，你可以运行`jar tvf`：
```shell
$ jar tvf target/myproject-0.0.1-SNAPSHOT.jar
```
在target目录下，你应该也能看到一个很小的名为`myproject-0.0.1-SNAPSHOT.jar.original`的文件。这是在Spring Boot重新打包前Maven创建的原始jar文件。

为了运行该应用程序，你可以使用`java -jar`命令：
```shell
$ java -jar target/myproject-0.0.1-SNAPSHOT.jar

  .   ____          _            __ _ _
 /\\ / ___'_ __ _ _(_)_ __  __ _ \ \ \ \
( ( )\___ | '_ | '_| | '_ \/ _` | \ \ \ \
 \\/  ___)| |_)| | | | | || (_| |  ) ) ) )
  '  |____| .__|_| |_|_| |_\__, | / / / /
 =========|_|==============|___/=/_/_/_/
 :: Spring Boot ::  (v1.3.0.BUILD-SNAPSHOT)
....... . . .
....... . . . (log output here)
....... . . .
........ Started Example in 2.536 seconds (JVM running for 2.864)
```
和以前一样，点击`ctrl-c`来温柔地退出程序。
